{extends file="layouts/main.tpl"}

{block name=contents}

<div class="section-wrap">
    <div class="section">
        <img src="{$app.logo}" style="margin-left:44%; margin-bottom: 10px;" alt="">
        <div class="form-popup">
            {$form_alert}
            <!-- FORM POPUP CONTENT -->
            <div class="form-popup-content">
                <h4 class="popup-title">Create Free Account</h4>
                <hr class="line-separator">
                <form action="{$url.main}auth/registration" method="post" id="demo-form">
                    {$csrf_token}
                    <label for="username5" class="rl-label">Firstname</label>
                    <input type="text" id="Firstname" name="firstname" required>

                    <label for="username5" class="rl-label">Lastname</label>
                    <input type="text" id="lastname" name="lastname" required>

                    <label for="username5" class="rl-label">Username</label>
                    <input type="text" id="username" name="username" required>

                    <label for="username5" class="rl-label">Email</label>
                    <input type="text" id="email" name="email" required>

                    <label for="username5" class="rl-label">Country</label>
                    <select id="country" class="gds-cr" country-data-region-id="gds-cr-one" name="country" required></select>

                    <label for="username5" class="rl-label">Region</label>
                    <select id="gds-cr-one" name="region" required></select>

                    <label for="password5" class="rl-label">Password</label>
                    <input type="password" id="password" name="password" required>

                    <label for="password5" class="rl-label">Confirm Password</label>
                    <input type="password" id="con_pass" name="con_pass" required>

                    <p>Forgot your password? <a href="{$url.main}auth/login" class="primary">Click here!</a></p>
                    <button type="submit" id="btn" name="do_reg" class="g-recaptcha button mid dark" data-sitekey="{$robot.p_key}" data-callback='onSubmit' {if $robot.isRobotCheck}disabled{/if}>Create <span class="primary">Account</span></button>
                </form>
            </div>
            <!-- /FORM POPUP CONTENT -->
        </div>
        <!-- /FORM POPUP -->
    </div>
</div>
    
{/block}

{block name=page_title}
<title>Create Account | {$app.name}</title>
{/block}

{block name=contry_script}
<script src="{$contf}/js/geodatasource-cr.min.js"></script>
{/block}

{block name=robot_check}
{if $robot.isRobotCheck}
    
    <script type="text/javascript" src="https://www.google.com/recaptcha/api.js" async defer></script>
<script type="text/javascript">
    {literal}
    function onSubmit(token) {
        document.getElementById('btn').disabled = false;
        document.getElementById("demo-form").submit();
    }
    {/literal}
</script>
{/if}
{/block}

{block name=country_head}
<link rel="stylesheet" href="{$contf}/css/geodatasource-countryflag.css">
<script type="text/javascript" src="{$contf}/js/Gettext.js"></script>
{/block}